/*
 * Decompiled with CFR 0.152.
 */
package xeij;

public class FFT {
    private int fftN;
    private double[] fftSinCos;
    private int[] fftSwap;

    public FFT(int n) {
        int n2;
        this.fftN = n;
        int n3 = n >> 1;
        int n4 = n >> 2;
        this.fftSinCos = new double[5 * n4 + 1];
        double d = Math.PI * 2 / (double)n;
        for (n2 = 1; n2 < n4; ++n2) {
            this.fftSinCos[n + n2] = this.fftSinCos[n2] = Math.sin(d * (double)n2);
            this.fftSinCos[n3 - n2] = this.fftSinCos[n2];
            double d2 = -this.fftSinCos[n2];
            this.fftSinCos[n3 + n2] = d2;
            this.fftSinCos[n - n2] = d2;
        }
        this.fftSinCos[0] = 0.0;
        this.fftSinCos[n3] = 0.0;
        this.fftSinCos[n] = 0.0;
        this.fftSinCos[n4] = 1.0;
        this.fftSinCos[5 * n4] = 1.0;
        this.fftSinCos[3 * n4] = -1.0;
        n2 = Integer.numberOfTrailingZeros(n);
        this.fftSwap = new int[n - (1 << (n2 + 1 >> 1))];
        int n5 = 0;
        for (int i = 0; i < n; ++i) {
            int n6 = Integer.reverse(i << -n2);
            if (i >= n6) continue;
            this.fftSwap[n5] = i;
            this.fftSwap[n5 + 1] = n6;
            n5 += 2;
        }
    }

    public void fftSandeTukey2(double[] dArray, double[] dArray2) {
        int n;
        int n2;
        int n3 = this.fftN >> 2;
        int n4 = this.fftN >> 1;
        int n5 = 1;
        while (n4 >= 1) {
            n2 = 0;
            n = 0;
            while (n2 < n4) {
                double d = this.fftSinCos[n + n3];
                double d2 = -this.fftSinCos[n];
                for (int i = 0; i < this.fftN; i += n4 << 1) {
                    int n6 = i + n2;
                    int n7 = n6 + n4;
                    double d3 = dArray[n6];
                    double d4 = dArray2[n6];
                    double d5 = dArray[n7];
                    double d6 = dArray2[n7];
                    dArray[n6] = d3 + d5;
                    dArray2[n6] = d4 + d6;
                    dArray[n7] = d * (d3 -= d5) - d2 * (d4 -= d6);
                    dArray2[n7] = d * d4 + d2 * d3;
                }
                ++n2;
                n += n5;
            }
            n4 >>= 1;
            n5 <<= 1;
        }
        n2 = this.fftSwap.length;
        for (n5 = 0; n5 < n2; n5 += 2) {
            n = this.fftSwap[n5];
            int n8 = this.fftSwap[n5 + 1];
            double d = dArray[n];
            dArray[n] = dArray[n8];
            dArray[n8] = d;
            d = dArray2[n];
            dArray2[n] = dArray2[n8];
            dArray2[n8] = d;
        }
    }

    public void fftSandeTukey4(double[] dArray, double[] dArray2) {
        double d;
        double d2;
        double d3;
        double d4;
        double d5;
        double d6;
        double d7;
        int n;
        int n2;
        int n3;
        int n4;
        int n5 = this.fftN - 1;
        int n6 = n4 = this.fftN >> 2;
        int n7 = 1;
        while (n6 >= 2) {
            n3 = 0;
            n2 = 0;
            while (n3 < n6) {
                n = n2 + n2 & n5;
                int n8 = n + n2 & n5;
                double d8 = this.fftSinCos[n2 + n4];
                double d9 = -this.fftSinCos[n2];
                double d10 = this.fftSinCos[n + n4];
                double d11 = -this.fftSinCos[n];
                double d12 = this.fftSinCos[n8 + n4];
                double d13 = -this.fftSinCos[n8];
                for (int i = 0; i < this.fftN; i += n6 << 2) {
                    int n9 = i + n3;
                    int n10 = n9 + n6;
                    int n11 = n10 + n6;
                    int n12 = n11 + n6;
                    d7 = dArray[n9];
                    d6 = dArray2[n9];
                    d5 = dArray[n10];
                    d4 = dArray2[n10];
                    d3 = dArray[n11];
                    d2 = dArray2[n11];
                    d = dArray[n12];
                    double d14 = dArray2[n12];
                    double d15 = d7 + d3;
                    double d16 = d5 + d;
                    dArray[n9] = d15 + d16;
                    double d17 = d6 + d2;
                    double d18 = d4 + d14;
                    dArray2[n9] = d17 + d18;
                    double d19 = d15 - d16;
                    double d20 = d17 - d18;
                    dArray[n10] = d10 * d19 - d11 * d20;
                    dArray2[n10] = d10 * d20 + d11 * d19;
                    d15 = d7 - d3;
                    d16 = d4 - d14;
                    d19 = d15 + d16;
                    d17 = d6 - d2;
                    d18 = d5 - d;
                    d20 = d17 - d18;
                    dArray[n11] = d8 * d19 - d9 * d20;
                    dArray2[n11] = d8 * d20 + d9 * d19;
                    d19 = d15 - d16;
                    d20 = d17 + d18;
                    dArray[n12] = d12 * d19 - d13 * d20;
                    dArray2[n12] = d12 * d20 + d13 * d19;
                }
                ++n3;
                n2 += n7;
            }
            n6 >>= 2;
            n7 <<= 2;
        }
        if (n6 == 1) {
            for (n7 = 0; n7 < this.fftN; n7 += 4) {
                n3 = n7 + 1;
                n2 = n7 + 2;
                n = n7 + 3;
                double d21 = dArray[n7];
                var12_44 = dArray2[n7];
                var14_45 = dArray[n3];
                double d22 = dArray2[n3];
                double d23 = dArray[n2];
                double d24 = dArray2[n2];
                double d25 = dArray[n];
                double d26 = dArray2[n];
                double d27 = d21 + d23;
                d7 = var12_44 + d24;
                d6 = d21 - d23;
                d5 = var12_44 - d24;
                d4 = var14_45 + d25;
                d3 = d22 + d26;
                d2 = var14_45 - d25;
                d = d22 - d26;
                dArray[n7] = d27 + d4;
                dArray2[n7] = d7 + d3;
                dArray[n3] = d27 - d4;
                dArray2[n3] = d7 - d3;
                dArray[n2] = d6 + d;
                dArray2[n2] = d5 - d2;
                dArray[n] = d6 - d;
                dArray2[n] = d5 + d2;
            }
        } else {
            for (n7 = 0; n7 < this.fftN; n7 += 2) {
                n3 = n7 + 1;
                double d28 = dArray[n7];
                double d29 = dArray2[n7];
                var12_44 = dArray[n3];
                var14_45 = dArray2[n3];
                dArray[n7] = d28 + var12_44;
                dArray2[n7] = d29 + var14_45;
                dArray[n3] = d28 - var12_44;
                dArray2[n3] = d29 - var14_45;
            }
        }
        n3 = this.fftSwap.length;
        for (n7 = 0; n7 < n3; n7 += 2) {
            int n13 = this.fftSwap[n7];
            n = this.fftSwap[n7 + 1];
            double d30 = dArray[n13];
            dArray[n13] = dArray[n];
            dArray[n] = d30;
            d30 = dArray2[n13];
            dArray2[n13] = dArray2[n];
            dArray2[n] = d30;
        }
    }
}

